/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.AttributedEntityAttributeModifier;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;

public class ConditionedAttributePower
extends Power {
    private final List<AttributedEntityAttributeModifier> modifiers = new LinkedList<AttributedEntityAttributeModifier>();
    private final int tickRate;

    public ConditionedAttributePower(PowerType<?> type, PlayerEntity player, int tickRate) {
        super(type, player);
        this.setTicking(true);
        this.tickRate = tickRate;
    }

    @Override
    public void tick() {
        if (this.player.field_70173_aa % this.tickRate == 0) {
            if (this.isActive()) {
                this.addMods();
            } else {
                this.removeMods();
            }
        }
    }

    @Override
    public void onRemoved() {
        this.removeMods();
    }

    public ConditionedAttributePower addModifier(AttributedEntityAttributeModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public void addMods() {
        this.modifiers.forEach(mod -> {
            ModifiableAttributeInstance instance;
            if (this.player.func_233645_dx_().func_233790_b_(mod.getAttribute()) && (instance = this.player.func_110148_a(mod.getAttribute())) != null && !instance.func_180374_a(mod.getModifier())) {
                instance.func_233767_b_(mod.getModifier());
            }
        });
    }

    public void removeMods() {
        this.modifiers.forEach(mod -> {
            ModifiableAttributeInstance instance;
            if (this.player.func_233645_dx_().func_233790_b_(mod.getAttribute()) && (instance = this.player.func_110148_a(mod.getAttribute())) != null && instance.func_180374_a(mod.getModifier())) {
                instance.func_111124_b(mod.getModifier());
            }
        });
    }
}

